#include <Carbon.h>
#include <math.h>
#define pi 3.141592653589
#define max 2500  /* itrations */
#define sy 300. /* position de dpart */
#define sx 15. /* position de dpart */
#define echelle 5

/*
   	"Fractale" Warthog  v 1.0   15/05/02

Fait avec CodeWarrior 7 (CodeWarrior IDE v4.2.5)

Ce programme fonctionne sur MacOS X
Configuration minimum : MacOS 8.6 avec CarbonLib 1.4

  2002 All Rights Reserved to Didier STRAUS

		http://www.Software-DS.com

Les courbes de Warthog ne sont pas des fractales au sens stricte,
mais elles sont aussi belles (c'est mon avis ;-)
Je ne vous ai fourni ici que quleques courbes de Warthog, je vous laisse dcouvrir
et chercher les autres en modifiant la fonction fx et dans certain cas en modifiant
le paramtre a (quand il y a un paramtre :-)

Pour en savoir plus sur les courbes de Warthog, je vous recommande
de lire le chapitre consacr  Warthog dans le livre:
Titre:   Visions gomtriques
Auteur:  Ian Stewart
Edition: Pour la science.Belin
*/

double fx(double n);

WindowRef 	gMainWindow;
WindowPtr	theWindow;
Boolean		gSystemIsMacOSX;

void main (void) {
	int k;
	double x,y,x1,y1;
	
	
	InitCursor();
	if (!(theWindow=GetNewCWindow(300,NULL,(WindowPtr)-1))) {
		SysBeep(5);
		ExitToShell();
	}
	SetPortWindowPort(theWindow);
	PenSize(1,1);
	
	if (gSystemIsMacOSX==true)
        ShowSheetWindow(theWindow,gMainWindow);
	else
		ShowWindow(theWindow);
	
	x=sx;
	y=sy;
	
	for(k=1;k<max;k++){		
		x1=x+echelle*cos(2*pi*fx(k));
		y1=y+echelle*sin(2*pi*fx(k));
		
		ForeColor(redColor); /* Couleur rouge */
		MoveTo(y,x);
		LineTo(y1,x1); /* On trace une ligne qui s'affichera avec : QDFlushPortBuffer(GetWindowPort(FrontWindow()),NULL); */
		x=x1;
		y=y1;
		QDFlushPortBuffer(GetWindowPort(FrontWindow()),NULL); /* Pour afficher le dessin au fure et  mesure qu'il se dessine */
	}

	while (!Button()){}; /* Pause: Attente d'un clic de souris. */
	while (Button()){};
/* 2002 All Rights Reserved to Didier STRAUS www.Software-DS.com  Software_DS@mac.com */
}

double fx(double n) {
	return log(n)*log(n)*log(n)*log(n); /* <=> (log(n))^4 */
}
